/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nymmd.types;

import jp.nyatla.nymmd.core.PmdBone;
import jp.nyatla.nymmd.types.BoneKeyFrame;
import jp.nyatla.nymmd.types.MmdVector3;
import jp.nyatla.nymmd.types.MmdVector4;

public class MotionData {
    public String szBoneName;
    public int ulNumKeyFrames;
    public BoneKeyFrame[] pKeyFrames;

    public void getMotionPosRot(float fFrame, PmdBone i_pmd_bone) {
        int lKey0;
        int lKey1;
        int ulNumKeyFrame = this.ulNumKeyFrames;
        BoneKeyFrame[] bone_key_frame = this.pKeyFrames;
        if (fFrame > bone_key_frame[ulNumKeyFrame - 1].fFrameNo) {
            fFrame = bone_key_frame[ulNumKeyFrame - 1].fFrameNo;
        }
        if ((lKey1 = (lKey0 = MotionData.findByBinarySearch(bone_key_frame, fFrame, 0, ulNumKeyFrame - 1) - 1) + 1) == ulNumKeyFrame) {
            lKey1 = ulNumKeyFrame - 1;
        }
        if (lKey0 < 0) {
            lKey0 = 0;
        }
        float fTime0 = bone_key_frame[lKey0].fFrameNo;
        float fTime1 = bone_key_frame[lKey1].fFrameNo;
        MmdVector3 pvec3Pos = i_pmd_bone.m_vec3Position;
        MmdVector4 pvec4Rot = i_pmd_bone.m_vec4Rotate;
        if (lKey0 != lKey1) {
            float fLerpValue = (fFrame - fTime0) / (fTime1 - fTime0);
            pvec3Pos.Vector3Lerp(bone_key_frame[lKey0].vec3Position, bone_key_frame[lKey1].vec3Position, fLerpValue);
            pvec4Rot.QuaternionSlerp(bone_key_frame[lKey0].vec4Rotate, bone_key_frame[lKey1].vec4Rotate, fLerpValue);
            pvec4Rot.QuaternionNormalize(pvec4Rot);
        } else {
            pvec3Pos.setValue(bone_key_frame[lKey0].vec3Position);
            pvec4Rot.setValue(bone_key_frame[lKey0].vec4Rotate);
        }
    }

    private static int findByBinarySearch(BoneKeyFrame[] pKeyFrames, float fFrame, int start, int end) {
        int diff = end - start;
        if (diff < 8) {
            for (int i = start; i < end; ++i) {
                if (!(fFrame < pKeyFrames[i].fFrameNo)) continue;
                return i;
            }
            return end;
        }
        int mid = (start + end) / 2;
        if (fFrame < pKeyFrames[mid].fFrameNo) {
            return MotionData.findByBinarySearch(pKeyFrames, fFrame, start, mid);
        }
        return MotionData.findByBinarySearch(pKeyFrames, fFrame, mid, end);
    }
}

